
#rem
433 MHz wireless reed switch program for 08M2 2.10.25
David Worboys
Baulkham Hills
#endrem

#picaxe 08M2
#no_data
'#terminal 4800

dirsc= %00010110	'C.1 C.2 C.4 set to outputs, C.3 as an input
pullup %00000000	'pullups OFF 

start:

high c.4									'power ON to 08m2

enabletime									'TIME used to track the door open time prior to SLEEP mode begin

if pinc.3 = 1 then :gosub buttonA :endif				'pulse buttonA if the reed switch is closed

L10:
if pinc.3 = 0 then :gosub buttonB :gosub PWR_off :endif	'if the door is closed
if time>=120 then :gosub SNOOZE :endif 				'if the door is open for 120 secs or more then SLEEP to save power
goto L10									'loop here (including SLEEP) until the door is closed

end

buttonB:
	for b2=0 to 1		'send buttonB twice, 1 second apart (possible improvement in the case of transient RF interference)
		pause 1000
		high c.2
		pause 1000
		low c.2
	next b2
return

buttonA:
	for b2=0 to 1		'send buttonA twice, 1 second apart (possible improvement in the case of transient RF interference)
		pause 1000
		high c.1
		pause 1000
		low c.1
	next b2
return

PWR_off:
	pause 500
	low c.4								'power OFF to 08m2
return

SNOOZE:
	'sertxd ("ASLEEP",10,13)
	disabletime								'disable TIME
	disablebod								'disable 08m2 black out detector
	
L20:	sleep 26								'sleep for 60 secs (2.3 x 26 = 60)
	if pinc.3=1 then :goto L20 :endif				'keep sleeping until the door is closed
	
	enablebod
	enabletime
	'sertxd ("AWAKE",10,13)
	time=0
	pause 1000
return